/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.embedded.ca.solostudios.stringsimilarity;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.anti_ad.embedded.ca.solostudios.stringsimilarity.interfaces.MetricStringDistance;
import org.anti_ad.embedded.ca.solostudios.stringsimilarity.interfaces.StringDistance;
import org.anti_ad.embedded.ca.solostudios.stringsimilarity.interfaces.StringSimilarity;
import org.anti_ad.embedded.ca.solostudios.stringsimilarity.util.ComparisonsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000b\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B%\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\r\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u000eR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0006\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0010\u001a\u0004\b\u0013\u0010\u0012R\u0017\u0010\u0007\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0010\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lorg/anti_ad/embedded/ca/solostudios/stringsimilarity/Levenshtein;", "Lorg/anti_ad/embedded/ca/solostudios/stringsimilarity/interfaces/MetricStringDistance;", "Lorg/anti_ad/embedded/ca/solostudios/stringsimilarity/interfaces/StringSimilarity;", "Lorg/anti_ad/embedded/ca/solostudios/stringsimilarity/interfaces/StringDistance;", "", "insertionWeight", "deletionWeight", "substitutionWeight", "<init>", "(DDD)V", "", "s1", "s2", "distance", "(Ljava/lang/String;Ljava/lang/String;)D", "similarity", "D", "getInsertionWeight", "()D", "getDeletionWeight", "getSubstitutionWeight", "kt-string-similarity"})
@SourceDebugExtension(value={"SMAP\nLevenshtein.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Levenshtein.kt\nca/solostudios/stringsimilarity/Levenshtein\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 Comparisons.kt\nca/solostudios/stringsimilarity/util/ComparisonsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n1188#2,2:147\n1188#2,2:149\n1190#2:152\n1190#2:154\n92#3:151\n1#4:153\n*S KotlinDebug\n*F\n+ 1 Levenshtein.kt\nca/solostudios/stringsimilarity/Levenshtein\n*L\n122#1:147,2\n126#1:149,2\n126#1:152\n122#1:154\n131#1:151\n*E\n"})
public final class Levenshtein
implements MetricStringDistance,
StringSimilarity,
StringDistance {
    private final double insertionWeight;
    private final double deletionWeight;
    private final double substitutionWeight;

    public Levenshtein(double insertionWeight, double deletionWeight, double substitutionWeight) {
        this.insertionWeight = insertionWeight;
        this.deletionWeight = deletionWeight;
        this.substitutionWeight = substitutionWeight;
        if (!(this.insertionWeight > 0.0 && this.insertionWeight < 1.0E10)) {
            boolean $i$a$-require-Levenshtein$42 = false;
            String $i$a$-require-Levenshtein$42 = "Insertion weight (" + this.insertionWeight + ") should be between 0 and 1*10^10";
            throw new IllegalArgumentException($i$a$-require-Levenshtein$42.toString());
        }
        if (!(this.deletionWeight > 0.0 && this.deletionWeight < 1.0E10)) {
            boolean $i$a$-require-Levenshtein$52 = false;
            String $i$a$-require-Levenshtein$52 = "Deletion weight (" + this.deletionWeight + ") should be between 0 and 1*10^10";
            throw new IllegalArgumentException($i$a$-require-Levenshtein$52.toString());
        }
        if (!(this.substitutionWeight > 0.0 && this.substitutionWeight < 1.0E10)) {
            boolean bl = false;
            String string = "Substitution weight (" + this.substitutionWeight + ") should be between 0 and 1*10^10";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ Levenshtein(double d, double d2, double d3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 1.0;
        }
        if ((n & 2) != 0) {
            d2 = 1.0;
        }
        if ((n & 4) != 0) {
            d3 = 1.0;
        }
        this(d, d2, d3);
    }

    public final double getInsertionWeight() {
        return this.insertionWeight;
    }

    public final double getDeletionWeight() {
        return this.deletionWeight;
    }

    public final double getSubstitutionWeight() {
        return this.substitutionWeight;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double distance(@NotNull String s1, @NotNull String s2) {
        Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
        if (Intrinsics.areEqual((Object)s1, (Object)s2)) {
            return 0.0;
        }
        if (((CharSequence)s1).length() == 0) {
            return (double)s2.length() * this.insertionWeight;
        }
        if (((CharSequence)s2).length() == 0) {
            return (double)s1.length() * this.deletionWeight;
        }
        Pair<String, String> pair = ComparisonsKt.minMaxByLength(s1, s2);
        String shorter = (String)pair.component1();
        String longer = (String)pair.component2();
        Ref.ObjectRef previousRow = new Ref.ObjectRef();
        previousRow.element = new double[shorter.length() + 1];
        Object currentRow = null;
        currentRow = new double[shorter.length() + 1];
        int i = 0;
        int n = shorter.length();
        if (i <= n) {
            while (true) {
                ((double[])previousRow.element)[i] = i;
                if (i == n) break;
                ++i;
            }
        }
        CharSequence $this$forEachIndexed$iv = longer;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (int j = 0; j < $this$forEachIndexed$iv.length(); ++j) {
            double[] dArray;
            char item$iv = $this$forEachIndexed$iv.charAt(j);
            int n2 = index$iv++;
            char c = item$iv;
            int i2 = n2;
            boolean bl = false;
            currentRow[0] = i2 + 1;
            CharSequence $this$forEachIndexed$iv2 = shorter;
            boolean $i$f$forEachIndexed22 = false;
            int index$iv2 = 0;
            for (int k = 0; k < $this$forEachIndexed$iv2.length(); ++k) {
                void b$iv;
                void a$iv;
                void c2;
                void c1;
                char item$iv2 = $this$forEachIndexed$iv2.charAt(k);
                int n3 = index$iv2++;
                char c3 = item$iv2;
                int j2 = n3;
                boolean bl2 = false;
                double deletionCost = ((double[])previousRow.element)[j2 + 1] + this.deletionWeight;
                double insertionCost = currentRow[j2] + this.insertionWeight;
                double substitutionCost = ((double[])previousRow.element)[j2] + (c1 == c2 ? 0.0 : this.substitutionWeight);
                double d = deletionCost;
                double d2 = insertionCost;
                double c$iv = substitutionCost;
                boolean $i$f$min = false;
                currentRow[j2 + 1] = Math.min(Math.min((double)a$iv, (double)b$iv), c$iv);
            }
            double[] $i$f$forEachIndexed22 = dArray = currentRow;
            Ref.ObjectRef objectRef = previousRow;
            boolean bl3 = false;
            currentRow = previousRow.element;
            objectRef.element = dArray;
        }
        return ArraysKt.last((double[])((double[])previousRow.element));
    }

    @Override
    public double similarity(@NotNull String s1, @NotNull String s2) {
        Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
        return (this.insertionWeight * (double)s1.length() + this.deletionWeight * (double)s2.length() - this.distance(s1, s2)) / (double)2;
    }

    public Levenshtein() {
        this(0.0, 0.0, 0.0, 7, null);
    }
}

